<?php defined('PF_VERSION') OR exit('Access denied');?>
<?php


//mail
require_once ABSPATH . "/includes/Swift/lib/swift_required.php";
class Pf_Mail extends Swift {
    protected $setting ;
    protected $sitename;
    protected $mailer;
    protected $db;
    public function __construct() {
            $this->setting    =   Pf::setting();
            $this->sitename =   $this->setting->get_element_value('general','site_name');
            $this->mailconfig   = get_configuration('mail_setting');
            if($this->mailconfig == 'SMTP'){
            $transport = Swift_SmtpTransport::newInstance(Pf::setting()->get_element_value('general','smtp_server'), Pf::setting()->get_element_value('general','smtp_port'))
                        ->setUsername(Pf::setting()->get_element_value('general','smtp_username'))
                        ->setPassword(Pf::setting()->get_element_value('general','smtp_password'));
            }
            else{
                $transport  = Swift_MailTransport::newInstance();
            }
            $this->mailer   = Swift_Mailer::newInstance($transport);
            $this->domain   = public_url('');
            $this->SentFrom  =   array(noreply_email() => $this->sitename." Administrator"); 
            $this->db   =   Pf::database();
        }
        private function replace_tpl($template, $username, $displayname, $email, $link){
            $template   =   str_replace("{username}", $username, $template);
            $template   =   str_replace("{displayname}", $displayname, $template);
            $template   =   str_replace("{email}", $email, $template);
            $template   =   str_replace("{link}", $link, $template);
            $template   =   str_replace("{sitename}", $this->sitename, $template);
            return $template;
        }
        public function mail_welcome($email, $username, $displayname){
            $content_tpl        =   Pf::email_template()->get_element_body('pf_user_mail_template','mail_welcome');
            $subject_tpl        =   Pf::email_template()->get_element_subject('pf_user_mail_template','mail_welcome');
            $content        = $this->replace_tpl($content_tpl, $username, $displayname, '', '');
            $subject        = $this->replace_tpl($subject_tpl, '', '', '', ''); 
                $message = Swift_Message::newInstance()
                            ->setSubject($subject)
                            ->setFrom($this->SentFrom)
                            ->setTo(array($email => $displayname))
                            ->setBody($content)
                            ;
                $this->mailer->send($message);
        }
        public function mail_forgot($email,$key) {
            $this->db->select('pf_users.id as uid,user_displayname,user_password','pf_users',"`user_email`='$email' and user_delete_flag=0");
            $info   =   $this->db->fetch_assoc_all();
            $displayname    =   $info[0]['user_displayname'];
            $uid            =   $info[0]['uid'];
            $password       =   $info[0]['user_password'];
            $link           =   $this->domain."user/user-page:reset/key:".$key;
            $content_tpl        =   Pf::email_template()->get_element_body('pf_user_mail_template','mail_forgot');
            $subject_tpl        =   Pf::email_template()->get_element_subject('pf_user_mail_template','mail_forgot');
            $content        = $this->replace_tpl($content_tpl, '', $displayname, '', $link);
            $subject        = $this->replace_tpl($subject_tpl, '', $displayname, '', $link); 
            $message = Swift_Message::newInstance()
                            ->setSubject($subject)
                            ->setFrom($this->SentFrom)
                            ->setTo(array($email => $displayname))
                            ->setBody($content)
                            ;
                $this->mailer->send($message);
        }
        public function mail_active($email, $displayname) {
            $this->db->select('pf_users.id as uid, user_name, user_activation_key','pf_users',"`user_email`=?",array($email));
            $info   =   $this->db->fetch_assoc_all();
            $uid =   $info[0]['uid'];
            $username   =   $info[0]['user_name'];
            $activekey  =   md5($info[0]['user_activation_key']);
            $link   =   $this->domain."user/user-page:activation/id:".$uid."/key:".$activekey;
            $content_tpl        =   Pf::email_template()->get_element_body('pf_user_mail_template','mail_active');
            $subject_tpl        =   Pf::email_template()->get_element_subject('pf_user_mail_template','mail_active');
            $content        = $this->replace_tpl($content_tpl, $username, $displayname, '', $link);
            $subject        = $this->replace_tpl($subject_tpl, '', '', '', ''); 
            $message = Swift_Message::newInstance()
                            ->setSubject($subject)
                            ->setFrom($this->SentFrom)
                            ->setTo(array($email => $displayname))
                            ->setBody($content)
                            ;
                $this->mailer->send($message);
        }
        public function mail_success_forgot($email) {
            $this->db->select('user_displayname,user_name','pf_users',"`user_email`='$email' and user_delete_flag=0");
            $info   =   $this->db->fetch_assoc_all();
            $displayname    =   $info[0]['user_displayname'];
            $username       =   $info[0]['user_name'];
            $content_tpl        =   Pf::email_template()->get_element_body('pf_user_mail_template','mail_success_forgot');
            $subject_tpl        =   Pf::email_template()->get_element_subject('pf_user_mail_template','mail_success_forgot');
            $content        = $this->replace_tpl($content_tpl, $username, $displayname, '', '');
            $subject        = $this->replace_tpl($subject_tpl, '', '', '', ''); 
            $message = Swift_Message::newInstance()
                            ->setSubject($subject)
                            ->setFrom($this->SentFrom)
                            ->setTo(array($email => $displayname))
                            ->setBody($content)
                            ;
                $this->mailer->send($message);
        }
}
